package kuchenKloneServer;

import java.text.*;
import java.util.Date;

/**
 * Schnittstellenobjekt Kuchen
 * 
 * @author Bernd Schubert
 * 
 */
public class Kuchen
{
  private int     ID;
  private String  anbieter;
  private int     sorte;
  private String  sorteName;
  private String  kurzkuchen;
  private String  beschreibung;
  private String  abgabedatum;
  private int     anzahl;
  private double  preis;
  private boolean diabetikergeeignet;
  private String  letzterzugriff;
  private boolean fehler;

  //Im Java soll per Festlegung das deutsche Datumsformat gelten, auch wenn SQLite dann was anderes will
  DateFormat      df = new SimpleDateFormat( "dd.MM.yyyy" );

  /**
   * Neuer Kuchen
   */
  public Kuchen()
  {
    setID( 0 );
    setAnbieter( "" );
    setSorte( 0 );
    setKurzkuchen( "" );
    setBeschreibung( "" );
    setAbgabedatum( df.format( new Date() ) );
    setAnzahl( 0 );
    setPreis( 0.0 );
    setDiabetikergeeignet( true );
    this.letzterzugriff = df.format( new Date() );
    this.fehler = false;
  }

  /**
   * Kuchen aus den gegebenen Werten
   * 
   * @param ID
   * @param anbieter
   * @param sorte
   * @param kurzkuchen
   * @param beschreibung
   * @param abgabedatum
   * @param anzahl
   * @param preis
   * @param diabetikergeeignet
   * @param letzterzugriff
   */
  public Kuchen(
      int ID,
      String anbieter,
      int sorte,
      String kurzkuchen,
      String beschreibung,
      String abgabedatum,
      int anzahl,
      double preis,
      boolean diabetikergeeignet,
      String letzterzugriff )
  {
    this.ID = ID;
    this.anbieter = anbieter;
    this.sorte = sorte;
    this.kurzkuchen = kurzkuchen;
    this.beschreibung = beschreibung;
    this.abgabedatum = abgabedatum;
    this.anzahl = anzahl;
    this.preis = preis;
    this.diabetikergeeignet = diabetikergeeignet;
    this.letzterzugriff = letzterzugriff;
    this.fehler = false;
  }

  /**
   * Kuchen aus dem CSV-Format
   * 
   * @param zeile
   */
  public Kuchen( String zeile )
  {
    String[] split = zeile.split( ";" );
    //Das Insert berschreibt die ID und letzten Zugriff jedoch spter
    try
    {
      this.fehler = false;
      this.ID = Integer.parseInt( split[0] );
      this.anbieter = split[1];
      this.sorte = Integer.parseInt( split[2] );
      this.kurzkuchen = split[3];
      this.beschreibung = split[4];
      this.abgabedatum = split[5];
      this.anzahl = Integer.parseInt( split[6] );
      this.preis = Double.parseDouble( split[7] );
      this.diabetikergeeignet = Boolean.parseBoolean( split[8] );
      this.letzterzugriff = split[9];
    }
    catch ( NumberFormatException e )
    {
      this.fehler = true;
      //System.err.println( "Fehler beim Konvertieren importierte Zeile: " + zeile );
    }

    //System.out.println("Ergebnis:" + getGesamt());
  }

  public int getID()
  {
    return ID;
  }

  public void setID( int ID )
  {
    this.ID = ID;
  }

  public boolean getFehler()
  {
    return fehler;
  }

  /**
   * 
   * @return Exportformat als CSV
   */
  public String getGesamt()
  {
    return String.valueOf( ID ) + ";" +
        anbieter + ";" +
        String.valueOf( sorte ) + ";" +
        kurzkuchen + ";" +
        beschreibung + ";" +
        abgabedatum + ";" +
        String.valueOf( anzahl ) + ";" +
        String.valueOf( preis ) + ";" +
        String.valueOf( diabetikergeeignet ) + ";" +
        letzterzugriff;
  }

  public String getAnbieter()
  {
    return anbieter;
  }

  public void setAnbieter( String anbieter )
  {
    this.anbieter = anbieter;
  }

  public int getSorte()
  {
    return sorte;
  }

  public void setSorte( int sorte )
  {
    this.sorte = sorte;
  }

  public String getKurzkuchen()
  {
    return kurzkuchen;
  }

  public void setKurzkuchen( String kurzkuchen )
  {
    this.kurzkuchen = kurzkuchen;
  }

  public String getBeschreibung()
  {
    return beschreibung;
  }

  public void setBeschreibung( String beschreibung )
  {
    this.beschreibung = beschreibung;
  }

  public String getAbgabedatum()
  {
    return abgabedatum;
  }

  public void setAbgabedatum( String abgabedatum )
  {
    this.abgabedatum = abgabedatum;
  }

  public int getAnzahl()
  {
    return anzahl;
  }

  public void setAnzahl( int anzahl )
  {
    this.anzahl = anzahl;
  }

  public double getPreis()
  {
    return preis;
  }

  public void setPreis( double preis )
  {
    this.preis = preis;
  }

  public boolean isDiabetikergeeignet()
  {
    return diabetikergeeignet;
  }

  public void setDiabetikergeeignet( boolean diabetikergeeignet )
  {
    this.diabetikergeeignet = diabetikergeeignet;
  }

  public String getLetzterzugriff()
  {
    return letzterzugriff;
  }

  public void setLetzterzugriff( String letzterzugriff )
  {
    this.letzterzugriff = letzterzugriff;
  }

  public String getSorteName()
  {
    return sorteName;
  }

  public void setSorteName( String sorteName )
  {
    this.sorteName = sorteName;
  }
}
