package util;

import java.awt.event.*;
import javax.swing.*;

public class WinUtil
{
  private WinUtil()
  {
  }

  public enum MenuItemType
  {
    ITEM_PLAIN, ITEM_CHECK, ITEM_RADIO
  }

  /**
   * 
   * @param menuBar
   * @param menuText
   * @param menuName
   * @param shortKey
   * @return menu
   */
  public static JMenu createMenu( JMenuBar menuBar, String menuText, String menuName, int shortKey )
  {
    JMenu menu = new JMenu();
    menu.setText( menuText );
    menu.setName( menuName );
    if ( shortKey > 0 )
      menu.setMnemonic( shortKey );

    menuBar.add( menu );

    return menu;
  }
  /**
   * 
   * @param ziel
   * , Als Zielobjekte sind derzeit MenuBar und Menu zugelassen
   * @param miText
   * @param miName
   * @param miType
   * @param actionListener
   * @param image
   * @param shortKey
   * @param miToolTip
   * @return menuItem
   */
  public static JMenuItem createMenuItem( Object ziel, String miText, String miName, MenuItemType miType,
      ActionListener actionListener, ImageIcon image, int shortKey, String miToolTip )
  {
    JMenuItem menuItem = null;
    
    if (ziel instanceof JMenu)
    {
      JMenu menu= (JMenu) ziel;
      menuItem=createMenuItemIntern( miText, miName, miType, actionListener, image, shortKey,  miToolTip );

      menu.add( menuItem );
    }

    if (ziel instanceof JMenuBar)
    {
      JMenuBar menuBar= (JMenuBar) ziel;
      menuItem=createMenuItemIntern( miText, miName, miType, actionListener, image, shortKey,  miToolTip );

      menuBar.add( menuItem );
    }
    
    return menuItem;
  }
  
  private static JMenuItem createMenuItemIntern( String miText, String miName, MenuItemType miType,
      ActionListener actionListener, ImageIcon image, int shortKey, String miToolTip )
  {
    JMenuItem menuItem = new JMenuItem();

    switch ( miType )
    {
      case ITEM_CHECK:
        menuItem = new JCheckBoxMenuItem();
        break;

      case ITEM_RADIO:
        menuItem = new JRadioButtonMenuItem();
        break;
    
      default:
        break;
    }

    menuItem.setName( miName );
    menuItem.setText( miText );
    menuItem.setIcon( image );

    if ( shortKey > 0 )
      menuItem.setMnemonic( shortKey );

    menuItem.setToolTipText( miToolTip );
    menuItem.addActionListener( actionListener );

    return menuItem;
  }

 }
